#ifndef OSPLINECOGWHEEL_H__
#define OSPLINECOGWHEEL_H__

enum
{
		PRIM_COGWHEEL_TEETH                     = 2080,
		PRIM_COGWHEEL_IRAD                      = 2082,
		PRIM_COGWHEEL_MRAD                      = 2083,
		PRIM_COGWHEEL_ORAD                      = 2084,
		PRIM_COGWHEEL_BEVEL                     = 2085,

		PRIM_COGWHEEL_TOOTH_TYPE                = 2086,
				PRIM_COGWHEEL_TOOTH_TYPE_INVOLUTE   = 0,
				PRIM_COGWHEEL_TOOTH_TYPE_RATCHET    = 1,
				PRIM_COGWHEEL_TOOTH_TYPE_NONE       = 2,
				PRIM_COGWHEEL_TOOTH_TYPE_FLAT       = 3,

		PRIM_COGWHEEL_PITCH_RADIUS              = 2088,
		PRIM_COGWHEEL_MODULE                    = 2089,
		PRIM_COGWHEEL_ADDENDUM                  = 2090,
		PRIM_COGWHEEL_DEDENDUM                  = 2091,
		PRIM_COGWHEEL_ADDENDUM_RADIUS           = 2092,
		PRIM_COGWHEEL_ROOT_RADIUS               = 2093,

		PRIM_COGWHEEL_PRESSURE_ANGLE            = 2096,
		PRIM_COGWHEEL_LEGACY_MODE               = 2097,
		PRIM_COGWHEEL_SHOW_GUIDES               = 2098,

		PRIM_COGWHEEL_RADIAL_RATIO              = 2099,
		PRIM_COGWHEEL_WITNESS_RATIO             = 2100,
		PRIM_COGWHEEL_UNDERCUT_RATIO            = 2101,

		PRIM_COGWHEEL_DIAMETRAL_PITCH           = 2102,

		PRIM_COGWHEEL_INLAY_TYPE                = 2103,
				PRIM_COGWHEEL_INLAY_TYPE_NONE       = 0,
				PRIM_COGWHEEL_INLAY_TYPE_SPOKES     = 1,
				PRIM_COGWHEEL_INLAY_TYPE_HOLES      = 2,
				PRIM_COGWHEEL_INLAY_TYPE_ARCHES     = 3,
				PRIM_COGWHEEL_INLAY_TYPE_WAVES      = 4,

		PRIM_COGWHEEL_SPOKES_COUNT              = 2104,
		PRIM_COGWHEEL_SPOKES_OUTER_RADIUS       = 2105,
		PRIM_COGWHEEL_SPOKES_INNER_RADIUS       = 2106,
		PRIM_COGWHEEL_SPOKES_OUTER_WIDTH        = 2107,
		PRIM_COGWHEEL_SPOKES_INNER_WIDTH        = 2108,

		PRIM_COGWHEEL_HOLES_COUNT               = 2109,
		PRIM_COGWHEEL_HOLES_RADIUS              = 2110,

		PRIM_COGWHEEL_CENTER_HOLE               = 2111,
		PRIM_COGWHEEL_CENTER_HOLE_RADIUS        = 2112,

		PRIM_COGWHEEL_CUTOUT                    = 2113,
		PRIM_COGWHEEL_CUTOUT_DEPTH              = 2114,
		PRIM_COGWHEEL_CUTOUT_WIDTH              = 2115,
		PRIM_COGWHEEL_CUTOUT_ORIENTATION        = 2116,

		PRIM_COGWHEEL_HOLES_DISTANCE            = 2117,
		PRIM_COGWHEEL_HOLES_ARC                 = 2118,

		PRIM_COGWHEEL_INLAY_ORIENTATION         = 2119,

		PRIM_COGWHEEL_ARCHES_COUNT              = 2120,
		PRIM_COGWHEEL_ARCHES_OUTER_RADIUS       = 2121,
		PRIM_COGWHEEL_ARCHES_INNER_RADIUS       = 2122,
		PRIM_COGWHEEL_ARCHES_ARC_FRACTION       = 2123,
		PRIM_COGWHEEL_ARCHES_STRETCH            = 2124,

		PRIM_COGWHEEL_WAVES_COUNT               = 2125,
		PRIM_COGWHEEL_WAVES_OUTER_RADIUS        = 2126,
		PRIM_COGWHEEL_WAVES_INNER_RADIUS        = 2127,
		PRIM_COGWHEEL_WAVES_FREQUENCY           = 2128,
		PRIM_COGWHEEL_WAVES_AMPLITUDE           = 2129,
		PRIM_COGWHEEL_WAVES_PHASE               = 2130,
		PRIM_COGWHEEL_WAVES_WIDTH               = 2131,

		PRIM_COGWHEEL_UNDERCUT                  = 2132,
		PRIM_COGWHEEL_GUIDE_COLOR               = 2140,

		PRIM_COGWHEEL_SPOKES_BEVEL              = 2135,

		PRIM_COGWHEEL_INLAY_INVERT              = 2136,
		PRIM_COGWHEEL_LOCK_RADIUS_FOR_TEETH     = 2137,
		PRIM_COGWHEEL_TEETH_ORIENTATION         = 2138,
		PRIM_COGWHEEL_TEETH2                    = 2139, // This is a necessary duplicate to allow the teeth parameter to automatically move between groups.

		ID_GROUP_INLAY = 2000,
		ID_GROUP_TEETH = 2001
};

#endif // OSPLINECOGWHEEL_H__
